/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.item.datacard;

import com.lothrazar.cyclic.ModCyclic;
import com.lothrazar.cyclic.block.TileBlockEntityCyclic;
import com.lothrazar.cyclic.item.ItemBaseCyclic;
import com.lothrazar.cyclic.util.ChatUtil;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class SettingsCard
extends ItemBaseCyclic {
    private static final String NBT_ID = "id";
    private static final String NBT_SETSAVED = "settingsSaved";

    public SettingsCard(Item.Properties properties) {
        super(properties.m_41487_(1));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        CompoundTag stackdata = stack.m_41784_();
        if (stackdata.m_128441_(NBT_ID)) {
            String tiledataID = stackdata.m_128461_(NBT_ID);
            TranslatableComponent t = new TranslatableComponent("[" + tiledataID + "]");
            t.m_130940_(ChatFormatting.DARK_GRAY);
            tooltip.add((Component)t);
        }
    }

    public InteractionResult m_6225_(UseOnContext context) {
        CompoundTag stackdata;
        Player player = context.m_43723_();
        InteractionHand hand = context.m_43724_();
        BlockPos pos = context.m_8083_();
        ItemStack held = player.m_21120_(hand);
        player.m_6674_(hand);
        BlockEntity tile = player.f_19853_.m_7702_(pos);
        if (player.f_19853_.m_8055_(pos).m_60734_() == Blocks.f_50752_) {
            held.m_41751_(null);
            ChatUtil.addChatMessage(player, this.m_5524_() + ".deleted");
        }
        if ((stackdata = held.m_41784_()) == null || stackdata.m_128456_()) {
            if (tile instanceof TileBlockEntityCyclic) {
                String[] wipers;
                CompoundTag tiledata = tile.serializeNBT();
                for (String wipe : wipers = new String[]{"x", "y", "z", "input", "output", "ForgeData", "ForgeCaps", "inv", "inventory", "energy", "fluid", "timer", "filter"}) {
                    tiledata.m_128473_(wipe);
                }
                tiledata.m_128379_(NBT_SETSAVED, true);
                held.m_41751_(tiledata);
                ChatUtil.addChatMessage(player, this.m_5524_() + ".savednew");
            }
        } else if (stackdata.m_128471_(NBT_SETSAVED)) {
            String stackdataID = stackdata.m_128461_(NBT_ID);
            if (tile instanceof TileBlockEntityCyclic) {
                CompoundTag tiledata = tile.serializeNBT();
                String tiledataID = stackdata.m_128461_(NBT_ID);
                if (tiledataID.equalsIgnoreCase(stackdataID)) {
                    stackdata = stackdata.m_6426_();
                    stackdata.m_128473_(NBT_SETSAVED);
                    stackdata.m_128473_(NBT_ID);
                    tiledata = tiledata.m_128391_(stackdata);
                    tile.m_142466_(tiledata);
                    ChatUtil.addChatMessage(player, this.m_5524_() + ".written");
                }
            }
        } else {
            ModCyclic.LOGGER.error("Invalid data tack settingsSaved : " + stackdata);
        }
        return InteractionResult.SUCCESS;
    }
}

